/*
 * VRT RULES
 * 
 * Copyright (C) 2005 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

   Custom detection by Patrick Mullen <pmullen@sourcefire.com>

   DOES NOT USE THE BUILT-IN DETECTION FUNCTIONALITY!!!

alert tcp $EXTERNAL_NET $HTTP_PORTS -> $HOME_NET any (msg:"WEB-CLIENT Microsoft Word ole stream memory corruption attempt"; flow:to_client,established; flowbits:isset,file.doc; content:"bjbj"; content:!"|00 00 00 00|"; distance:62; within:4; reference:url,technet.microsoft.com/en-us/security/bulletin/ms08-009; reference:cve,2008-0109;  metadata:policy balanced-ips drop, policy security-ips drop, service http; classtype:attempted-user; sid:13469; rev:1;)


 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule13469eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_client; */
static FlowFlags rule13469flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule13469option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13469flow0
    }
};
/* flowbits:isset "file.doc"; */
static FlowBitsInfo rule13469flowbits1 =
{
    "file.doc",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule13469option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule13469flowbits1
    }
};
// content:"bjbj"; 
static ContentInfo rule13469content2 = 
{
    (uint8_t *)"bjbj", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13469option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13469content2
    }
};
// content:"|00 00 00 00|", offset 62, depth 4, relative; 
static ContentInfo rule13469content3 = 
{
    (uint8_t *)"|00 00 00 00|", /* pattern (now in snort content format) */
    4, /* depth */
    62, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13469option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13469content3
    }
};


static RuleMetaData rule13469service1 =
{
    "service http"
};

static RuleMetaData rule13469policy1 =
{
   "policy max-detect-ips drop"
};

static RuleMetaData *rule13469metadata[] =
{
    &rule13469service1,
    &rule13469policy1,
    NULL
};

/* references for sid 13469 */
/* reference: cve "2008-0109"; */

static RuleReference rule13469ref1 = 
{
    "cve", /* type */
    "2008-0109" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/ms08-009"; */
static RuleReference rule13469ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/ms08-009" /* value */
};

static RuleReference *rule13469refs[] =
{
    &rule13469ref1,
    &rule13469ref2,
    NULL
};
RuleOption *rule13469options[] =
{
    &rule13469option0,
    &rule13469option1,
    &rule13469option2,
    &rule13469option3,
    NULL
};

Rule rule13469 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13469, /* sigid 1490ec8c-c7e9-4aed-af87-94612a12d8b8 */
       11, /* revision ed16b2f0-2389-4023-b7e2-364cd45397ba */
   
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-OFFICE Microsoft Word ole stream memory corruption attempt",     /* message */
       rule13469refs /* ptr to references */
       ,rule13469metadata
   },
   rule13469options, /* ptr to rule options */
   &rule13469eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule13469eval(void *p) {
    const uint8_t *cursor_normal = 0;
    const uint8_t *beg_of_payload, *end_of_payload;
    uint32_t length;

    SFSnortPacket *sp = (SFSnortPacket *) p;

    // flow:established, to_client;
    if (checkFlow(p, rule13469options[0]->option_u.flowFlags) > 0 ) {
        // flowbits:isset "file.doc";
        if (processFlowbits(p, rule13469options[1]->option_u.flowBit) > 0) {

            // content:"bjbj";
            if (contentMatch(p, rule13469options[2]->option_u.content, &cursor_normal) > 0) {
                // content:"|00 00 00 00|", offset 62, depth 4, relative;
                if (!(contentMatch(p, rule13469options[3]->option_u.content, &cursor_normal) > 0)) {

                if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
                    return RULE_NOMATCH;

                // At this point, cursor_normal is still right after bjbj because negative
                // content matches do not move the pointer
                // Start custom detection here
                if((cursor_normal + 572) > end_of_payload)
                   return RULE_NOMATCH;

                cursor_normal += 568;
                length = *cursor_normal++;
                length |= *cursor_normal++ << 8;
                length |= *cursor_normal++ << 16;
                length |= *cursor_normal++ << 24;

                if((length - 4) % 0x1a)
                   return RULE_MATCH;
                }
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13469,
    NULL
};
*/
